<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'img_cover', 'logo', 'tags', 'slug', 'note', 'gallery', 'activation', 'user_id', 'feedback_id', 'store_payment_id', 'store_location_id');
    protected $visible = array('name', 'description', 'img_cover', 'logo', 'tags', 'slug', 'note', 'gallery', 'activation', 'user_id', 'feedback_id', 'store_payment_id', 'store_location_id');

    public function products()
    {
        return $this->hasMany('App\Models\Product', 'product_id');
    }

    public function users()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function feedbacks()
    {
        return $this->belongsTo('App\Models\Feedback');
    }

    public function storePayments()
    {
        return $this->belongsTo('App\Models\StorePayment');
    }

    public function storeLocations()
    {
        return $this->belongsTo('App\Models\StoreLocation');
    }

}